﻿using UnityEngine;

public class MeteorSpawn : MonoBehaviour
{
	public GameObject meteorPrefab;
	public float minSpawnDelay = 1f;
	public float maxSpawnDelay = 3f;
	public float spawnXLimit = 6f;

	void Start()
	{
		Spawn();
	}

	void Spawn()
	{
		// Create a meteor at a random x position
		float random = Random.Range(-spawnXLimit, spawnXLimit);
		Vector3 spawnPos = transform.position + new Vector3(random, 0f, 0f);
		Instantiate(meteorPrefab, spawnPos, Quaternion.identity);

		Invoke("Spawn", Random.Range(minSpawnDelay, maxSpawnDelay));
	}
}
